package gov.va.med.mhv.usermgmt.essapi.service;


import gov.va.med.mhv.usermgmt.essapi.transfer.NotificationTO;

import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Produces({"application/xml","application/json"})
@Consumes({"application/xml","application/json"})
public interface NotificationAPIService {

	@GET
	@Path("/rx")
	public Response getRxNotification();	
	
	@POST
	@Path("/rx")
	public Response setRxNotification(NotificationTO notiTO);
	
	// Added for JAZZ 601513: Add Newsletter Subscription to Registration Page
	// TODO: What is the path for these next two?...
	@GET
	@Path("/rx")
	public Response getNewsletterNotification();	
	
	@POST
	@Path("/rx")
	public Response setNewsletterNotification(NotificationTO notiTO);
	
	@GET
	@Path("/appt")
	public Response getApptNotification();

	@POST
	@Path("/appt")
	public Response setApptNotification(NotificationTO notiTO);

	@GET
	@Path("/email")
	public Response getEmailAddrsNotification();

	@POST
	@Path("/email")
	public Response setEmailAddrsNotification(NotificationTO notiTO);
	
}
